/*
 * Decompiled with CFR 0.152.
 */
package de.miraisoft.loginmessages;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.miraisoft.loginmessages.LMFormatter;
import de.miraisoft.loginmessages.LoginMessagesMod;
import de.miraisoft.loginmessages.MessageUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.StringTokenizer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LMCommand
implements Command<CommandSourceStack> {
    private static final Logger logger = LogManager.getLogger();
    private static final String ARG0 = "arg0";
    private static final String ARG1 = "arg1";
    private static final String ADD = "add";
    private static final String LIST = "list";
    private static final String REMOVE = "remove";
    private static final String REMOVEALL = "removeall";
    private static final String HELP = "help";
    private static final int MESSAGE_LENGTH_LIMIT = 100;

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        try {
            if (context.getArgument(ARG0, String.class) != null) {
                File file = LoginMessagesMod.getFile();
                String arg0Value = (String)context.getArgument(ARG0, String.class);
                if (ADD.equals(arg0Value) && context.getArgument(ARG1, String.class) != null) {
                    this.addLoginMessage(context, player, file);
                } else if (REMOVEALL.equals(arg0Value)) {
                    this.removeAllLoginMessages(player, file);
                } else if (LIST.equals(arg0Value)) {
                    this.listLoginMessages(player, file);
                } else if (REMOVE.equals(arg0Value) && context.getArgument(ARG1, String.class) != null) {
                    this.removeSingleLoginMessage(context, player, file);
                } else if (HELP.equals(arg0Value)) {
                    this.displayUsageHelp(player);
                }
            }
        }
        catch (CommandSyntaxException cse) {
            throw cse;
        }
        catch (Exception e) {
            logger.error("[run] Error during command execution", (Throwable)e);
            Message message = MessageUtil.create("Error during command execution: " + e.getMessage());
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(MessageUtil.emptyMessage()), message);
        }
        return 0;
    }

    private void removeSingleLoginMessage(CommandContext<CommandSourceStack> context, ServerPlayer player, File file) throws CommandSyntaxException {
        block11: {
            try {
                boolean removed = false;
                if (file.exists()) {
                    String arg1 = (String)context.getArgument(ARG1, String.class);
                    StringTokenizer tokenizer = new StringTokenizer(arg1, " ");
                    int messageIndex = -1;
                    try {
                        messageIndex = Integer.parseInt(tokenizer.nextToken());
                    }
                    catch (Exception e) {
                        logger.error("[removeSingleLoginMessage] Cannot remove message", (Throwable)e);
                        Message message = MessageUtil.create("Can't remove message. Usage example: /loginmessage remove 1");
                        throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(MessageUtil.emptyMessage()), message);
                    }
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    StringBuffer messageBuffer = new StringBuffer();
                    int n = 0;
                    while (reader.ready()) {
                        String line = reader.readLine();
                        if (++n == messageIndex) {
                            removed = true;
                            continue;
                        }
                        if (messageBuffer.length() > 0) {
                            messageBuffer.append("\n");
                        }
                        messageBuffer.append(line);
                    }
                    reader.close();
                    if (messageBuffer.length() == 0) {
                        file.delete();
                    } else {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(file, false));
                        writer.write(messageBuffer.toString());
                        writer.close();
                    }
                    Object feedback = null;
                    feedback = removed ? "Login message " + messageIndex + " has been removed from list" : "No login message has been removed";
                    MessageUtil.send((Player)player, (String)feedback);
                    break block11;
                }
                MessageUtil.send((Player)player, "There are no messages to remove");
            }
            catch (CommandSyntaxException cse) {
                throw cse;
            }
            catch (Exception e) {
                logger.error("[removeSingleLoginMessage] Cannot remove message", (Throwable)e);
                Message message = MessageUtil.create("Cannot remove message: " + e.getMessage());
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(MessageUtil.emptyMessage()), message);
            }
        }
    }

    private void listLoginMessages(ServerPlayer player, File file) throws CommandSyntaxException {
        try {
            if (file.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                int n = 0;
                while (reader.ready()) {
                    String loginMessage = ++n + ") " + reader.readLine();
                    MessageUtil.send((Player)player, loginMessage);
                }
                reader.close();
            } else {
                MessageUtil.send((Player)player, "There are no login messages listed");
            }
        }
        catch (Exception e) {
            logger.error("[listLoginMessages] Cannot display list", (Throwable)e);
            Message message = MessageUtil.create("Cannot display list: " + e.getMessage());
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(MessageUtil.emptyMessage()), message);
        }
    }

    private void removeAllLoginMessages(ServerPlayer player, File file) throws CommandSyntaxException {
        try {
            if (file.exists()) {
                file.delete();
                MessageUtil.send((Player)player, "All login messages have been removed");
            } else {
                MessageUtil.send((Player)player, "There are no messages to remove");
            }
        }
        catch (Exception e) {
            logger.error("[removeAllLoginMessages] Cannot remove messages", (Throwable)e);
            Message message = MessageUtil.create("Cannot remove messages: " + e.getMessage());
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(MessageUtil.emptyMessage()), message);
        }
    }

    private void addLoginMessage(CommandContext<CommandSourceStack> context, ServerPlayer player, File file) throws CommandSyntaxException {
        try {
            String arg1 = (String)context.getArgument(ARG1, String.class);
            if (arg1.length() > 100) {
                MessageUtil.send((Player)player, "Message is too long. The limit is 100 characters!");
                return;
            }
            StringBuffer loginMessage = new StringBuffer();
            if (file.exists()) {
                loginMessage.append("\n");
            }
            loginMessage.append(arg1);
            BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));
            writer.write(LMFormatter.convertToMCText(loginMessage.toString()));
            writer.close();
            MessageUtil.send((Player)player, "Login message has been added to list");
        }
        catch (Exception e) {
            logger.error("[addLoginMessage] Cannot add message", (Throwable)e);
            Message message = MessageUtil.create("Cannot add message: " + e.getMessage());
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(MessageUtil.emptyMessage()), message);
        }
    }

    private void displayUsageHelp(ServerPlayer player) throws CommandSyntaxException {
        String[] examples = new String[]{"/loginmessage add Welcome to the server!", "/loginmessage list", "/loginmessage remove 1", "/loginmessage removeall", "/loginmessage add <<c>>Red Text", "/loginmessage add Hello <<playername>>!"};
        MessageUtil.send((Player)player, "Command usage examples:");
        for (String example : examples) {
            MessageUtil.send((Player)player, example);
        }
    }
}

